<?php
/**
 * Displays side panel
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */
$sp_classes = apply_filters( 'decibel_side_panel_class', '' );
?>
<div id="side-panel" class="side-panel <?php echo decibel_sanitize_html_classes( $sp_classes ); ?>">
	<div class="side-panel-inner">
		<?php
			/* Side Panel start hook */
			do_action( 'decibel_sidepanel_start' );

		if ( decibel_get_theme_mod( 'sidepanel_content_block_id' ) ) {

			echo '<div id="side-panel-block" class="sidebar-container sidebar-side-panel">';
			echo '<div class="sidebar-inner">';
			echo ( function_exists( 'decibel_get_block' ) ) ? decibel_get_block( decibel_get_theme_mod( 'sidepanel_content_block_id' ) ) : '';
			echo '</div>';
			echo '</div>';

		} else {
			get_sidebar( 'side-panel' );
		}
		?>
	</div><!-- .side-panel-inner -->
</div><!-- .side-panel -->
