<?php
/**
 * Template part for displaying posts with the "lateral" display
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

extract( wp_parse_args( $template_args, array(
	'post_excerpt_length' => 'shorten',
	'post_display_elements' => 'show_thumbnail,show_date,show_text,show_author,show_category',
	'post_alternate_thumbnail_position' => '',
	'index' => 0,
) ) );

$even_class = '';

$even = ( $index % 2 === 0 );
$odd = ( $index % 2 !== 0 );



if ( $odd && $post_alternate_thumbnail_position ) {
	$even_class = 'odd';
} elseif ( $even && $post_alternate_thumbnail_position ) {
	$even_class = 'even';
}

$post_display_elements = decibel_list_to_array( $post_display_elements );
$show_thumbnail = ( in_array( 'show_thumbnail', $post_display_elements ) );
$show_date = ( in_array( 'show_date', $post_display_elements ) );
$show_text = ( in_array( 'show_text', $post_display_elements ) );
$show_author = ( in_array( 'show_author', $post_display_elements ) );
$show_category = ( in_array( 'show_category', $post_display_elements ) );
$show_tags = ( in_array( 'show_tags', $post_display_elements ) );
$show_extra_meta = ( in_array( 'show_extra_meta', $post_display_elements ) );
?>
<article <?php decibel_post_attr(); ?>>
	<div class="entry-box">
		<div class="entry-container <?php echo esc_attr( $even_class ); ?>">

			<?php if ( $odd || ! $post_alternate_thumbnail_position ) : ?>
				<?php if ( $show_thumbnail ) : ?>
					<?php if ( decibel_has_post_thumbnail() || decibel_is_instagram_post() ) : ?>
						<div class="entry-image">
							<?php if ( $show_category ) : ?>
								<a class="category-label" href="<?php echo decibel_get_first_category_url(); ?>"><?php echo decibel_get_first_category(); ?></a>
							<?php endif; ?>
							<div class="entry-lateral-cover">
								<a href="<?php the_permalink(); ?>">
								<?php
									echo decibel_background_img( array(
										'background_img_size' => 'large',
										'placeholder_fallback' => true,
									) );
								?>
								</a>
							</div><!-- entry-cover -->
						</div><!-- .entry-image -->
					<?php endif; ?>
				<?php endif; ?>
			<?php endif ?>
			<div class="entry-summary">
				<div class="entry-summary-inner">
					<?php if ( ! is_sticky() && $show_date ) : ?>
						<span class="entry-date">
							<?php decibel_entry_date(); ?>
						</span>
					<?php endif; ?>
						<?php
							if ( is_sticky() && ! is_paged() ) {
								echo '<span class="sticky-post" title="' . esc_attr( __( 'Featured', 'decibel' ) ) . '"></span>';
							}
						?>
						<?php the_title( '<h2 class="entry-title"><a class="entry-link" href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>
					<?php if ( $show_text ) : ?>
						<div class="entry-excerpt">
							<?php if ( 'full' === $post_excerpt_length ) : ?>
								<?php echo decibel_sample( get_the_excerpt(), 1000 ); ?>
							<?php else : ?>
								<?php echo decibel_sample( get_the_excerpt(), decibel_get_excerpt_lenght() ); ?>
							<?php endif; ?>
							<span class="read-more">
								<a href="<?php the_permalink(); ?>" class="<?php echo esc_attr( apply_filters( 'decibel_more_link_button_class', '' ) ); ?>">
								<?php echo decibel_kses( apply_filters( 'decibel_read_more_text', esc_html__( 'Read more', 'decibel' ) ) ); ?>
								</a>
							</span>
						</div><!-- .entry-excerpt -->
					<?php endif; ?>
					<?php if ( $show_category && ( ! decibel_has_post_thumbnail() || ! $show_thumbnail ) ) : ?>
						<div class="entry-category-list">
							<?php echo get_the_term_list( get_the_ID(), 'category', esc_html__( 'In', 'decibel' ) . ' ', esc_html__( ', ', 'decibel' ), '' ) ?>

						</div>
					<?php endif; ?>
				</div><!-- .entry-summary-inner -->
				<?php if ( $show_author || $show_tags || $show_extra_meta || decibel_edit_post_link( false ) ) : ?>
					<div class="entry-meta">
						<?php if ( $show_author ) : ?>
							<?php decibel_get_author_avatar(); ?>
						<?php endif; ?>
						<?php if ( $show_tags ) : ?>
							<?php decibel_entry_tags(); ?>
						<?php endif; ?>
						<?php if ( $show_extra_meta ) : ?>
							<?php decibel_get_extra_meta(); ?>
						<?php endif; ?>
						<?php decibel_edit_post_link(); ?>
					</div><!-- .entry-meta -->
				<?php endif; ?>
			</div><!-- .entry-summary -->
			<?php if ( $even && $post_alternate_thumbnail_position ) : ?>
				<?php if ( $show_thumbnail ) : ?>
					<?php if ( decibel_has_post_thumbnail() || decibel_is_instagram_post() ) : ?>
						<div class="entry-image">
							<?php if ( $show_category ) : ?>
								<a class="category-label" href="<?php echo decibel_get_first_category_url(); ?>"><?php echo decibel_get_first_category(); ?></a>
							<?php endif; ?>
							<div class="entry-lateral-cover">
								<a href="<?php the_permalink(); ?>">
								<?php
									echo decibel_background_img( array(
										'background_img_size' => 'large',
										'placeholder_fallback' => true,
									) );
								?>
								</a>
							</div><!-- entry-cover -->
						</div><!-- .entry-image -->
					<?php endif; ?>
				<?php endif; ?>
			<?php endif ?>
		</div><!-- .entry-container -->
	</div><!-- .entry-box -->
</article><!-- #post-## -->