<?php
/**
 * Template part for displaying posts with the "grid" display
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

extract(
	wp_parse_args(
		$template_args,
		array(
			'display'               => 'masonry',
			'post_excerpt_length'   => 'shorten',
			'post_display_elements' => 'show_thumbnail,show_date,show_text,show_author,show_category',
		)
	)
);

$post_display_elements = decibel_list_to_array( $post_display_elements );
$the_permalink         = ( 'link' === get_post_format() ) ? decibel_get_first_url( get_the_ID() ) : get_the_permalink();
$target                = ( 'link' === get_post_format() ) ? '_blank' : '_parent';
?>
<article <?php decibel_post_attr(); ?>>
	<a href="<?php echo esc_url( $the_permalink ); ?>" target="<?php echo esc_attr( $target ); ?>" class="entry-link-mask"></a>
	<div class="entry-box">
		<div class="entry-container">
			<?php
				/**
				 * Hook: decibel_before_post_content_masonry.
				 *
				 * @hooked decibel_output_post_content_masonry_sticky_label - 10
				 */
				do_action( 'decibel_before_post_content_masonry', $post_display_elements, $display );

				/**
				 * Hook: decibel_before_post_content_masonry_title.
				 *
				 * @hooked decibel_output_post_content_masonry_media - 10
				 * @hooked decibel_output_post_content_masonry_date - 10
				 */
				do_action( 'decibel_before_post_content_masonry_title', $post_display_elements );

				/**
				 * Hook: decibel_post_content_masonry_title.
				 *
				 * @hooked decibel_output_post_content_masonry_title - 10
				 */
				do_action( 'decibel_post_content_masonry_title', $post_display_elements, $display );

				/**
				 * Hook: decibel_after_post_content_masonry_title.
				 *
				 * @hooked decibel_output_post_content_masonry_excerpt - 10
				 */
				do_action( 'decibel_after_post_content_masonry_title', $post_display_elements, $post_excerpt_type );

				/**
				 * Hook: decibel_after_post_content_masonry.
				 *
				 * @hooked decibel_output_post_content_masonry_meta - 10
				 */
				do_action( 'decibel_after_post_content_masonry', $post_display_elements );
			?>
		</div><!-- .entry-container -->
	</div><!-- .entry-box -->
</article><!-- #post-## -->
